<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>

<body <?php body_class('business-consulting'); ?>>
<?php wp_body_open(); ?>

<!-- Back To Top -->
<div class="xb-backtotop">
    <a href="#" class="scroll">
        <i class="far fa-arrow-up"></i>
    </a>
</div>

<!-- Preloader -->
<!--<div id="preloader" class="xb-loader">
    <div class="xb-loader-inner">
        <div class="loading-wave">
            <div class="loading-bar"></div>
            <div class="loading-bar"></div>
            <div class="loading-bar"></div>
            <div class="loading-bar"></div>
        </div>
    </div>
</div>-->

<div class="body_wrap o-clip">

<!-- Header Start -->
<header id="xb-header-area" class="header-area header-style header-transparent is-sticky"> 
    <div class="xb-header stricky">
        <div class="container-fluid p-0">
            <div class="header__wrap ul_li_between mlr-70">

                <!-- Logo -->
                <div class="xb-header-logo">
                    <?php
                    if ( has_custom_logo() ) {
                        the_custom_logo();
                    } else { ?>
                        <a href="<?php echo home_url(); ?>">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/img/logo/logo.svg" alt="<?php bloginfo('name'); ?>">
                        </a>
                    <?php } ?>
                </div>

                <!-- Desktop Menu -->
                <div class="header-right-inner ul_li">
                    <div class="main-menu__wrap navbar navbar-expand-lg p-0">
                        <nav class="main-menu collapse navbar-collapse">
                            <?php
                            wp_nav_menu(array(
                                'theme_location' => 'primary',
                                'container'      => false,
                                'menu_class'     => '',
                                'fallback_cb'    => false,
                            ));
                            ?>
                        </nav>
                    </div>

                    <!-- Mobile Toggle -->
                    <div class="header-bar-mobile side-menu d-lg-none">
                        <a class="xb-nav-mobile" href="javascript:void(0);">
                            <i class="far fa-bars"></i>
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </div>
</header>
<!-- Header End -->
